<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hierarchy extends Webpages {

// Hierarchy Settings


var $node		= array(); // The record from the DB, if existing
var $adult		= array(); // The adult, if a child
var $children	= array(); // The children, if an adult
var $twin		= array(); // Children that have the same parent and get pushed onto the same order inside the parent
var $sibling	= array(); // Next child from same parent, but already in place
var $baby		= array(); // If no order, just add the baby to the end of the family


var $nodelft	= '';
var $nodergt	= '';

var $adultlft	= '';
var $adultrgt	= '';

var $childlft	= '';
var $childrgt	= '';

var $twinlft	= '';
var $twinrgt	= '';

var $siblft		= '';
var $sibrgt		= '';

var $babylft	= '';
var $babyrgt	= '';



public function set()
	{
	if(empty($this->webpages->record) || $this->webpages->record['contentorder']!=$this->admin->postdata['contentorder'])
		{
		$this->family();
		
		$this->realorder();
		}
	}

private function family()
	{
	$this->node = $this->webpages->record;
	
	// Only run this if the order changes	
	
	$this->adult();
	
	if(empty($this->node))
		{
		$this->insertion();	
		}
	elseif($this->node['contentorder']!=$this->admin->postdata['contentorder'])
		{
		$this->adjustment();
		}
	}

// The parent of the record
private function adult()
	{
	$this->adult = $this->db->where('coid', $this->admin->postdata['pcoid'])->get('content')->row_array();
	
	if(!empty($this->adult))
		{
		$this->adultlft = $this->adult['contentnodel'];
		$this->adultrgt = $this->adult['contentnoder'];	
		}	
	}

private function insertion()
	{
	$this->admin->postdata['pcoid'] = $this->admin->postdata['pcoid']=='' ? '0' : $this->admin->postdata['pcoid'];
	
	// This just gets added to the end
	if($this->admin->postdata['contentorder']=='')
		{
		$this->baby = $this->db->where('pcoid', $this->admin->postdata['pcoid'])->order_by('contentorder', 'desc')->limit(1)->get('content')->row_array();
		
		if(!empty($this->baby))
			{
			$this->babylft = $this->baby['contentnodel'];
			$this->babyrgt = $this->baby['contentnoder'];
			
			$this->admin->postdata['contentnodel'] = $this->babylft + 2;
			$this->admin->postdata['contentnoder'] = $this->babyrgt + 2;
			
			if($this->admin->postdata['pcoid']!='0')
				{
				$l = $this->db->where(array('contentnoder >=' => $this->admin->postdata['contentnodel']))->get('content')->result_array();	
				$p = array();
				
				foreach($l as $c)
					{
					if($c['contentnodel'] < $this->admin->postdata['contentnodel'])
						{
						$p[] = array(	'coid' => $c['coid'],
										'contentnoder' => $c['contentnoder'] + 2
										);	
						}
					else
						{
						$p[] = array(	'coid' => $c['coid'],
										'contentnodel' => $c['contentnodel'] + 2,
										'contentnoder' => $c['contentnoder'] + 2
										);
						}
					}
				
				if(!empty($p))
					{
					$this->db->update_batch('content', $p, 'coid');	
					}
				}
			}
		else
			{
			$this->admin->postdata['contentnodel'] = 1;
			$this->admin->postdata['contentnoder'] = 2;	
			}
		}
	else
		{
		$this->sibling = $this->db->where(array('pcoid' => $this->admin->postdata['pcoid'], 'contentorder <=' => $this->admin->postdata['contentorder']))->order_by('contentorder', 'desc')->limit(1)->get('content')->row_array();
		
		if(!empty($this->sibling))
			{
			$this->siblft = $this->sibling['contentnodel'];
			$this->sibrgt = $this->sibling['contentnoder'];
			
			$this->admin->postdata['contentnodel'] = $this->siblft + 2;
			$this->admin->postdata['contentnoder'] = $this->sibrgt + 2;
			
			$l = $this->db->where(array('contentnoder >=' => $this->admin->postdata['contentnoder']))->get('content')->result_array();	
			$p = array();
			
			foreach($l as $c)
				{
				if($c['contentnodel'] < $this->admin->postdata['contentnodel'])
					{
					$p[] = array(	'coid' => $c['coid'],
									'contentnoder' => $c['contentnoder'] - 2
									);	
					}
				else
					{
					$p[] = array(	'coid' => $c['coid'],
									'contentnodel' => $c['contentnodel'] - 2,
									'contentnoder' => $c['contentnoder'] - 2
									);
					}
				}
			
			if(!empty($p))
				{
				$this->db->update_batch('content', $p, 'coid');	
				}
			}
		else
			{
			$this->admin->postdata['contentnodel'] = 1;
			$this->admin->postdata['contentnoder'] = 2;	
			}	
		}
	}

private function adjustment()
	{
	// Remove it from the list and then push it in again as a new item using insertion
	$this->admin->postdata['pcoid'] = $this->admin->postdata['pcoid']=='' ? '0' : $this->admin->postdata['pcoid'];
	
	$l = $this->db->where(array('contentnoder >=' => $this->node['contentnoder']))->get('content')->result_array();	
	$p = array();
	
	$step = $this->node['contentnodel']-1;
	
	foreach($l as $c)
		{
		$p[] = array(	'coid' => $c['coid'],
						'contentnodel' => $step-1,
						'contentnoder' => $step-1
						);
		}
	
	if(!empty($p))
		{
		$this->db->update_batch('content', $p, 'coid');	
		}
	
	$this->insertion();		
	}
	

private function realorder()
	{
	if($this->admin->postdata['pcoid']!='' && $this->admin->postdata['pcoid']!=0)
		{
		$o 	= $this->adult['contentrealorder'];
		
		if($this->admin->postdata['contentorder']==0 || $this->admin->postdata['contentorder']=='')
			{
			$this->admin->postdata['contentorder'] = isset($this->baby['contentorder']) ? $this->baby['contentorder']+1 : 1;
			}
		else
			{
			$this->admin->postdata['contentorder'] = isset($this->sibling['contentorder']) ? $this->sibling['contentorder']+1 : $this->admin->postdata['contentorder'];
			}
			
		$this->admin->postdata['contentrealorder']	= $o.'.'.str_pad($this->admin->postdata['contentorder'], 2, 0, STR_PAD_LEFT);
		}
	else
		{
		$this->admin->postdata['contentrealorder']	= str_pad($this->admin->postdata['contentorder'], 2, 0, STR_PAD_LEFT);
		}	
	}


}